<?php
// إحصائيات النظام
$total_cars = $conn->query("SELECT COUNT(*) as count FROM cars")->fetch_assoc()['count'];
$available_cars = $conn->query("SELECT COUNT(*) as count FROM cars WHERE status = 'available'")->fetch_assoc()['count'];
$rented_cars = $conn->query("SELECT COUNT(*) as count FROM cars WHERE status = 'rented'")->fetch_assoc()['count'];
$total_bookings = $conn->query("SELECT COUNT(*) as count FROM bookings")->fetch_assoc()['count'];
$pending_bookings = $conn->query("SELECT COUNT(*) as count FROM bookings WHERE status = 'pending'")->fetch_assoc()['count'];

// أحدث الحجوزات
$recent_bookings = $conn->query("SELECT b.*, c.brand, c.model FROM bookings b LEFT JOIN cars c ON b.car_id = c.id ORDER BY b.created_at DESC LIMIT 5");
?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="icon">🚗</div>
        <h3>إجمالي السيارات</h3>
        <div class="number"><?php echo $total_cars; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="icon">✅</div>
        <h3>السيارات المتاحة</h3>
        <div class="number"><?php echo $available_cars; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="icon">🔑</div>
        <h3>السيارات المؤجرة</h3>
        <div class="number"><?php echo $rented_cars; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="icon">📋</div>
        <h3>إجمالي الحجوزات</h3>
        <div class="number"><?php echo $total_bookings; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="icon">⏳</div>
        <h3>الحجوزات المعلقة</h3>
        <div class="number"><?php echo $pending_bookings; ?></div>
    </div>
</div>

<div class="table-container">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">أحدث الحجوزات</h2>
    <table>
        <thead>
            <tr>
                <th>رقم الحجز</th>
                <th>اسم العميل</th>
                <th>السيارة</th>
                <th>تاريخ البداية</th>
                <th>تاريخ النهاية</th>
                <th>الحالة</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($recent_bookings->num_rows > 0): ?>
                <?php while($booking = $recent_bookings->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $booking['id']; ?></td>
                        <td><?php echo htmlspecialchars($booking['customer_name']); ?></td>
                        <td><?php echo htmlspecialchars($booking['brand'] . ' ' . $booking['model']); ?></td>
                        <td><?php echo date('Y-m-d', strtotime($booking['start_date'])); ?></td>
                        <td><?php echo date('Y-m-d', strtotime($booking['end_date'])); ?></td>
                        <td>
                            <?php 
                            $status_ar = [
                                'pending' => 'معلق',
                                'confirmed' => 'مؤكد',
                                'cancelled' => 'ملغي'
                            ];
                            echo $status_ar[$booking['status']];
                            ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" style="text-align: center;">لا توجد حجوزات حتى الآن</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>